/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.deploy.ftp.ui.wizard;

import com.aptana.deploy.ftp.ui.wizard.Messages;
import com.aptana.ide.core.io.IBaseRemoteConnectionPoint;
import com.aptana.ide.syncing.ui.preferences.IPreferenceConstants;
import com.aptana.ui.ftp.internal.FTPConnectionPropertyComposite;
import com.aptana.ui.secureftp.internal.CommonFTPConnectionPropertyComposite;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class FTPDeployComposite
extends CommonFTPConnectionPropertyComposite
implements SelectionListener {
    private Button autoSyncCheckbox;
    private Button uploadButton;
    private Button downloadButton;
    private Button syncButton;

    public FTPDeployComposite(Composite parent, int style, IBaseRemoteConnectionPoint connectionPoint, FTPConnectionPropertyComposite.IListener listener) {
        super(parent, style, connectionPoint, listener);
        this.createAutoSyncOptions((Composite)this);
        this.optionsExpandable.setExpanded(true);
    }

    public boolean isAutoSyncSelected() {
        return this.autoSyncCheckbox.getSelection();
    }

    public IPreferenceConstants.SyncDirection getSyncDirection() {
        if (this.uploadButton.getSelection()) {
            return IPreferenceConstants.SyncDirection.UPLOAD;
        }
        if (this.downloadButton.getSelection()) {
            return IPreferenceConstants.SyncDirection.DOWNLOAD;
        }
        return IPreferenceConstants.SyncDirection.BOTH;
    }

    public void setAutoSyncSelected(boolean selected) {
        this.autoSyncCheckbox.setSelection(selected);
        this.updateEnableState();
    }

    public void setSyncDirection(IPreferenceConstants.SyncDirection direction) {
        if (direction != null) {
            switch (direction) {
                case UPLOAD: {
                    this.uploadButton.setSelection(true);
                    this.downloadButton.setSelection(false);
                    this.syncButton.setSelection(false);
                    break;
                }
                case DOWNLOAD: {
                    this.downloadButton.setSelection(true);
                    this.uploadButton.setSelection(false);
                    this.syncButton.setSelection(false);
                    break;
                }
                case BOTH: {
                    this.syncButton.setSelection(true);
                    this.uploadButton.setSelection(false);
                    this.downloadButton.setSelection(false);
                }
            }
        }
    }

    private void createAutoSyncOptions(Composite parent) {
        Composite sync = new Composite(parent, 0);
        sync.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        sync.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000008).span(2, 1).create());
        this.autoSyncCheckbox = new Button(sync, 32);
        this.autoSyncCheckbox.setText(Messages.FTPDeployComposite_AutoSync);
        this.autoSyncCheckbox.addSelectionListener((SelectionListener)this);
        this.uploadButton = new Button(sync, 16);
        this.uploadButton.setText(Messages.FTPDeployComposite_Upload);
        this.uploadButton.setLayoutData((Object)GridDataFactory.swtDefaults().indent(10, 0).create());
        this.downloadButton = new Button(sync, 16);
        this.downloadButton.setText(Messages.FTPDeployComposite_Download);
        this.downloadButton.setLayoutData((Object)GridDataFactory.swtDefaults().indent(10, 0).create());
        this.syncButton = new Button(sync, 16);
        this.syncButton.setText(Messages.FTPDeployComposite_Synchronize);
        this.syncButton.setLayoutData((Object)GridDataFactory.swtDefaults().indent(10, 0).create());
        this.syncButton.setSelection(true);
        this.updateEnableState();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source == this.autoSyncCheckbox) {
            this.updateEnableState();
        }
    }

    private void updateEnableState() {
        boolean enabled = this.autoSyncCheckbox.getSelection();
        this.uploadButton.setEnabled(enabled);
        this.downloadButton.setEnabled(enabled);
        this.syncButton.setEnabled(enabled);
    }
}

